/*
 * Decompiled with CFR 0.152.
 */
package uk.co.westhawk.snmp.stack;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import uk.co.westhawk.snmp.stack.AsnObject;
import uk.co.westhawk.snmp.stack.AsnPduSequence;
import uk.co.westhawk.snmp.stack.AsnSequence;
import uk.co.westhawk.snmp.stack.DecodingException;
import uk.co.westhawk.snmp.stack.Pdu;
import uk.co.westhawk.snmp.stack.SnmpContextBasisFace;
import uk.co.westhawk.snmp.stack.varbind;

public class MultiResponsePdu
extends Pdu {
    private static final String version_id = "@(#)$Id: MultiResponsePdu.java,v 3.3 2007/10/17 10:44:09 birgita Exp $ Copyright Westhawk Ltd";
    private Hashtable responses = new Hashtable();
    private String thisIP = null;

    public MultiResponsePdu(SnmpContextBasisFace con) {
        super(con);
        this.setRetryIntervals(new int[]{3000});
    }

    public String getSourceAgent() {
        return this.thisIP;
    }

    public int getNumResponses() {
        return this.responses.size();
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        if (!this.answered) {
            buffer.append(this.toString(false));
        } else {
            Enumeration ipaddrs = this.responses.keys();
            String ipaddr = (String)ipaddrs.nextElement();
            this.respVarbinds = (Vector)this.responses.get(ipaddr);
            buffer.append(this.toString(true));
            buffer.append(" rhost=").append(ipaddr);
            int i = 2;
            while (ipaddrs.hasMoreElements()) {
                ipaddr = (String)ipaddrs.nextElement();
                this.respVarbinds = (Vector)this.responses.get(ipaddr);
                buffer.append("\n\t");
                buffer.append(this.printVars("respVarbinds" + i, this.respVarbinds));
                buffer.append(" rhost=").append(ipaddr);
                ++i;
            }
        }
        return buffer.toString();
    }

    protected void tell_them() {
        String sender = this.thisIP;
        if (this.isTimedOut()) {
            sender = null;
        } else {
            this.responses.put(sender, this.respVarbinds);
        }
        this.notifyObservers(sender);
        this.respVarbinds = null;
        this.thisIP = null;
    }

    void fillin(AsnPduSequence seq) {
        if (this.answered) {
            if (AsnObject.debug > 6) {
                System.out.println(this.getClass().getName() + ".fillin(): " + "Got a second answer to request " + this.getReqId());
            }
            return;
        }
        this.thisIP = this.getContext().getReceivedFromHostAddress();
        if (this.responses.containsKey(this.thisIP)) {
            if (AsnObject.debug > 6) {
                System.out.println(this.getClass().getName() + ".fillin(): " + "Got a second answer from " + this.thisIP + " to request " + this.getReqId());
            }
            return;
        }
        if (seq != null) {
            if (seq.isCorrect) {
                int n = -1;
                try {
                    this.req_id = seq.getReqId();
                    this.setErrorStatus(seq.getWhatError());
                    this.setErrorIndex(seq.getWhereError());
                    AsnSequence varBind = seq.getVarBind();
                    int size = varBind.getObjCount();
                    this.respVarbinds = new Vector(size, 1);
                    for (n = 0; n < size; ++n) {
                        AsnObject obj = varBind.getObj(n);
                        if (!(obj instanceof AsnSequence)) continue;
                        AsnSequence varSeq = (AsnSequence)obj;
                        try {
                            varbind vb = new varbind(varSeq);
                            this.respVarbinds.addElement(vb);
                            this.new_value(n, vb);
                            continue;
                        }
                        catch (IllegalArgumentException exc) {
                            // empty catch block
                        }
                    }
                    if (this.reqVarbinds.isEmpty()) {
                        this.reqVarbinds = (Vector)this.respVarbinds.clone();
                    }
                }
                catch (Exception e) {
                    DecodingException exc = new DecodingException("Incorrect varbind list, element " + n);
                    this.setErrorStatus(20, exc);
                }
            } else {
                DecodingException exc = new DecodingException("Incorrect packet. No of bytes received less than packet length.");
                this.setErrorStatus(21, exc);
            }
        }
        this.setChanged();
        this.tell_them();
        this.clearChanged();
    }
}

