/*
 * Decompiled with CFR 0.152.
 */
package uk.co.westhawk.snmp.beans;

import java.io.IOException;
import java.util.Observable;
import java.util.Observer;
import uk.co.westhawk.snmp.beans.ncdPart;
import uk.co.westhawk.snmp.pdu.GetNextPdu_vec;
import uk.co.westhawk.snmp.pdu.GetPdu_vec;
import uk.co.westhawk.snmp.stack.AsnInteger;
import uk.co.westhawk.snmp.stack.AsnOctets;
import uk.co.westhawk.snmp.stack.PduException;
import uk.co.westhawk.snmp.stack.SnmpContext;
import uk.co.westhawk.snmp.stack.varbind;

class user
extends ncdPart
implements Observer {
    private static final String USER = "USER";
    private static final String ncdPrefEnvVarTableIndex = "1.3.6.1.4.1.82.2.3.15.54.1.1";
    private static final String ncdPrefEnvVarTableName = "1.3.6.1.4.1.82.2.3.15.54.1.2";
    private static final String ncdPrefEnvVarTableValue = "1.3.6.1.4.1.82.2.3.15.54.1.3";
    private int index = -1;
    private String name = "";
    private String prevName = "";
    GetNextPdu_vec namePdu;
    GetPdu_vec userPdu = null;
    private boolean first = true;
    private boolean isNcd = false;
    private boolean foundUser = false;

    public user(String h, int p, String c, int i, SnmpContext con) {
        super(h, p, c, i, con);
    }

    public String getUserName() {
        return this.name;
    }

    public void doPdu() throws PduException, IOException {
        if (this.first || this.isNcd && !this.foundUser) {
            this.namePdu = new GetNextPdu_vec(this.context, 3);
            this.namePdu.addObserver(this);
            this.namePdu.addOid(ncdPrefEnvVarTableIndex);
            this.namePdu.addOid(ncdPrefEnvVarTableName);
            this.namePdu.addOid(ncdPrefEnvVarTableValue);
            this.namePdu.send();
            this.first = false;
        } else if (this.foundUser) {
            this.userPdu = new GetPdu_vec(this.context, 3);
            this.userPdu.addObserver(this);
            this.userPdu.addOid("1.3.6.1.4.1.82.2.3.15.54.1.1." + this.index);
            this.userPdu.addOid("1.3.6.1.4.1.82.2.3.15.54.1.2." + this.index);
            this.userPdu.addOid("1.3.6.1.4.1.82.2.3.15.54.1.3." + this.index);
            this.userPdu.send();
        }
    }

    public void update(Observable obs, Object ov) {
        if (obs == this.namePdu) {
            if (this.namePdu.getErrorStatus() == 0) {
                varbind[] vars = (varbind[])ov;
                if (vars[0].getOid().toString().startsWith(ncdPrefEnvVarTableIndex)) {
                    this.isNcd = true;
                    int i = ((AsnInteger)vars[0].getValue()).getValue();
                    String n = ((AsnOctets)vars[1].getValue()).getValue();
                    String v = "";
                    if (vars[2].getValue() instanceof AsnOctets) {
                        v = ((AsnOctets)vars[2].getValue()).getValue();
                    }
                    if (n.equals(USER)) {
                        this.index = i;
                        this.foundUser = true;
                        this.name = v;
                        this.isPduInFlight = false;
                    } else {
                        this.namePdu = new GetNextPdu_vec(this.context, 3);
                        this.namePdu.addObserver(this);
                        this.namePdu.addOid(vars[0]);
                        this.namePdu.addOid(vars[1]);
                        this.namePdu.addOid(vars[2]);
                        try {
                            this.namePdu.send();
                        }
                        catch (PduException exc) {
                            System.out.println("PduException " + exc.getMessage());
                        }
                        catch (IOException exc) {
                            System.out.println("IOException " + exc.getMessage());
                        }
                    }
                } else {
                    this.name = this.isNcd ? "no one is logged in" : "not available";
                    if (!this.name.equals(this.prevName)) {
                        this.firePropertyChange("User", this.prevName, this.name);
                    }
                    this.prevName = this.name;
                    this.isPduInFlight = false;
                }
            } else {
                this.prevName = this.name;
                this.isPduInFlight = false;
            }
        } else {
            this.name = "";
            if (this.userPdu.getErrorStatus() == 0) {
                varbind[] vars = (varbind[])ov;
                int i = ((AsnInteger)vars[0].getValue()).getValue();
                String n = ((AsnOctets)vars[1].getValue()).getValue();
                String v = "";
                if (vars[2].getValue() instanceof AsnOctets) {
                    v = ((AsnOctets)vars[2].getValue()).getValue();
                }
                this.name = v;
                if (!this.name.equals(this.prevName)) {
                    this.firePropertyChange("User", this.prevName, this.name);
                }
            } else {
                this.first = true;
                this.isNcd = true;
                this.foundUser = false;
            }
            this.prevName = this.name;
            this.isPduInFlight = false;
        }
    }
}

