/*
 * Decompiled with CFR 0.152.
 */
package org.spongycastle.pqc.jcajce.provider.xmss;

import java.io.IOException;
import java.security.PrivateKey;
import org.spongycastle.asn1.ASN1Encodable;
import org.spongycastle.asn1.ASN1ObjectIdentifier;
import org.spongycastle.asn1.pkcs.PrivateKeyInfo;
import org.spongycastle.asn1.x509.AlgorithmIdentifier;
import org.spongycastle.crypto.CipherParameters;
import org.spongycastle.pqc.asn1.PQCObjectIdentifiers;
import org.spongycastle.pqc.asn1.XMSSKeyParams;
import org.spongycastle.pqc.asn1.XMSSPrivateKey;
import org.spongycastle.pqc.crypto.xmss.BDS;
import org.spongycastle.pqc.crypto.xmss.XMSSParameters;
import org.spongycastle.pqc.crypto.xmss.XMSSPrivateKeyParameters;
import org.spongycastle.pqc.crypto.xmss.XMSSUtil;
import org.spongycastle.pqc.jcajce.interfaces.XMSSKey;
import org.spongycastle.pqc.jcajce.provider.xmss.DigestUtil;
import org.spongycastle.util.Arrays;

public class BCXMSSPrivateKey
implements PrivateKey,
XMSSKey {
    private final XMSSPrivateKeyParameters keyParams;
    private final ASN1ObjectIdentifier treeDigest;

    public BCXMSSPrivateKey(ASN1ObjectIdentifier treeDigest, XMSSPrivateKeyParameters keyParams) {
        this.treeDigest = treeDigest;
        this.keyParams = keyParams;
    }

    public BCXMSSPrivateKey(PrivateKeyInfo keyInfo) throws IOException {
        XMSSKeyParams keyParams = XMSSKeyParams.getInstance((Object)keyInfo.getPrivateKeyAlgorithm().getParameters());
        this.treeDigest = keyParams.getTreeDigest().getAlgorithm();
        XMSSPrivateKey xmssPrivateKey = XMSSPrivateKey.getInstance((Object)keyInfo.parsePrivateKey());
        try {
            XMSSPrivateKeyParameters.Builder keyBuilder = new XMSSPrivateKeyParameters.Builder(new XMSSParameters(keyParams.getHeight(), DigestUtil.getDigest(this.treeDigest))).withIndex(xmssPrivateKey.getIndex()).withSecretKeySeed(xmssPrivateKey.getSecretKeySeed()).withSecretKeyPRF(xmssPrivateKey.getSecretKeyPRF()).withPublicSeed(xmssPrivateKey.getPublicSeed()).withRoot(xmssPrivateKey.getRoot());
            if (xmssPrivateKey.getBdsState() != null) {
                keyBuilder.withBDSState((BDS)XMSSUtil.deserialize((byte[])xmssPrivateKey.getBdsState()));
            }
            this.keyParams = keyBuilder.build();
        }
        catch (ClassNotFoundException e) {
            throw new IOException("ClassNotFoundException processing BDS state: " + e.getMessage());
        }
    }

    public String getAlgorithm() {
        return "XMSS";
    }

    public String getFormat() {
        return "PKCS#8";
    }

    public byte[] getEncoded() {
        try {
            AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier(PQCObjectIdentifiers.xmss, (ASN1Encodable)new XMSSKeyParams(this.keyParams.getParameters().getHeight(), new AlgorithmIdentifier(this.treeDigest)));
            PrivateKeyInfo pki = new PrivateKeyInfo(algorithmIdentifier, (ASN1Encodable)this.createKeyStructure());
            return pki.getEncoded();
        }
        catch (IOException e) {
            return null;
        }
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof BCXMSSPrivateKey) {
            BCXMSSPrivateKey otherKey = (BCXMSSPrivateKey)o;
            return this.treeDigest.equals((Object)otherKey.treeDigest) && Arrays.areEqual((byte[])this.keyParams.toByteArray(), (byte[])otherKey.keyParams.toByteArray());
        }
        return false;
    }

    public int hashCode() {
        return this.treeDigest.hashCode() + 37 * Arrays.hashCode((byte[])this.keyParams.toByteArray());
    }

    CipherParameters getKeyParams() {
        return this.keyParams;
    }

    private XMSSPrivateKey createKeyStructure() {
        byte[] keyData = this.keyParams.toByteArray();
        int n = this.keyParams.getParameters().getDigestSize();
        int totalHeight = this.keyParams.getParameters().getHeight();
        int indexSize = 4;
        int secretKeySize = n;
        int secretKeyPRFSize = n;
        int publicSeedSize = n;
        int rootSize = n;
        int position = 0;
        int index = (int)XMSSUtil.bytesToXBigEndian((byte[])keyData, (int)position, (int)indexSize);
        if (!XMSSUtil.isIndexValid((int)totalHeight, (long)index)) {
            throw new IllegalArgumentException("index out of bounds");
        }
        byte[] secretKeySeed = XMSSUtil.extractBytesAtOffset((byte[])keyData, (int)(position += indexSize), (int)secretKeySize);
        byte[] secretKeyPRF = XMSSUtil.extractBytesAtOffset((byte[])keyData, (int)(position += secretKeySize), (int)secretKeyPRFSize);
        byte[] publicSeed = XMSSUtil.extractBytesAtOffset((byte[])keyData, (int)(position += secretKeyPRFSize), (int)publicSeedSize);
        byte[] root = XMSSUtil.extractBytesAtOffset((byte[])keyData, (int)(position += publicSeedSize), (int)rootSize);
        byte[] bdsStateBinary = XMSSUtil.extractBytesAtOffset((byte[])keyData, (int)(position += rootSize), (int)(keyData.length - position));
        return new XMSSPrivateKey(index, secretKeySeed, secretKeyPRF, publicSeed, root, bdsStateBinary);
    }

    ASN1ObjectIdentifier getTreeDigestOID() {
        return this.treeDigest;
    }

    public int getHeight() {
        return this.keyParams.getParameters().getHeight();
    }

    public String getTreeDigest() {
        return DigestUtil.getXMSSDigestName(this.treeDigest);
    }
}

