/*
 * Decompiled with CFR 0.152.
 */
package org.spongycastle.cert.dane;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.spongycastle.cert.X509CertificateHolder;
import org.spongycastle.cert.dane.DANEEntry;
import org.spongycastle.cert.dane.DANEEntryFetcherFactory;
import org.spongycastle.cert.dane.DANEEntrySelector;
import org.spongycastle.cert.dane.DANEEntrySelectorFactory;
import org.spongycastle.cert.dane.DANEException;
import org.spongycastle.operator.DigestCalculator;

public class DANECertificateFetcher {
    private final DANEEntryFetcherFactory fetcherFactory;
    private final DANEEntrySelectorFactory selectorFactory;

    public DANECertificateFetcher(DANEEntryFetcherFactory fetcherFactory, DigestCalculator digestCalculator) {
        this.fetcherFactory = fetcherFactory;
        this.selectorFactory = new DANEEntrySelectorFactory(digestCalculator);
    }

    public List fetch(String emailAddress) throws DANEException {
        DANEEntrySelector daneSelector = this.selectorFactory.createSelector(emailAddress);
        List matches = this.fetcherFactory.build(daneSelector.getDomainName()).getEntries();
        ArrayList<X509CertificateHolder> certs = new ArrayList<X509CertificateHolder>(matches.size());
        for (DANEEntry next : matches) {
            if (!daneSelector.match(next)) continue;
            certs.add(next.getCertificate());
        }
        return Collections.unmodifiableList(certs);
    }
}

